function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) { n[e] = r[e]; } return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0) { ; } } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import React, { useState } from 'react';
import PropTypes from "prop-types";
import { OuiAccordion } from '../accordion';
import { htmlIdGenerator } from '../../services';
import { useOuiI18n } from '../i18n';
import { OuiText } from '../text';
export var OuiNotificationEventMessages = function OuiNotificationEventMessages(_ref) {
  var messages = _ref.messages,
    eventName = _ref.eventName;
  var _useState = useState(false),
    _useState2 = _slicedToArray(_useState, 2),
    isOpen = _useState2[0],
    setIsOpen = _useState2[1];
  var messagesLength = messages.length;
  var accordionButtonText = useOuiI18n('ouiNotificationEventMessages.accordionButtonText', '+ {messagesLength} more', {
    messagesLength: messagesLength - 1
  });
  var accordionAriaLabelButtonText = useOuiI18n('ouiNotificationEventMessages.accordionAriaLabelButtonText', '+ {messagesLength} messages for {eventName}', {
    messagesLength: messagesLength - 1,
    eventName: eventName
  });
  var accordionHideText = useOuiI18n('ouiNotificationEventMessages.accordionHideText', 'hide');
  var buttonContentText = isOpen ? "".concat(accordionButtonText, " (").concat(accordionHideText, ")") : accordionButtonText;
  return /*#__PURE__*/React.createElement("div", {
    className: "ouiNotificationEventMessages"
  }, messages && messagesLength === 1 ? /*#__PURE__*/React.createElement(OuiText, {
    size: "s",
    color: "subdued"
  }, /*#__PURE__*/React.createElement("p", null, messages)) : /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(OuiText, {
    size: "s",
    color: "subdued"
  }, /*#__PURE__*/React.createElement("p", null, messages[0])), /*#__PURE__*/React.createElement(OuiAccordion, {
    onToggle: setIsOpen,
    buttonProps: {
      'aria-label': accordionAriaLabelButtonText
    },
    id: htmlIdGenerator('ouiNotificationEventMessagesAccordion')(),
    className: "ouiNotificationEventMessages__accordion",
    buttonContent: buttonContentText,
    buttonClassName: "ouiNotificationEventMessages__accordionButton",
    arrowDisplay: "none"
  }, /*#__PURE__*/React.createElement("div", {
    className: "ouiNotificationEventMessages__accordionContent"
  }, messages.map(function (notification, index) {
    return /*#__PURE__*/React.createElement(OuiText, {
      size: "s",
      key: index,
      color: "subdued"
    }, /*#__PURE__*/React.createElement("p", null, notification));
  }).slice(1)))));
};

/* OUI -> EUI Aliases: Build-Time */
OuiNotificationEventMessages.propTypes = {
  /*
     * An array of strings that get individually wrapped in `<p>` tags
     */
  messages: PropTypes.arrayOf(PropTypes.string.isRequired).isRequired,
  /**
     * A unique, human-friendly name for the event to be used in aria attributes (e.g. "alert-critical-01", "cloud-no-severity-12", etc..).
     */
  eventName: PropTypes.string.isRequired
};
/* OUI -> EUI Aliases: Build-Time */export { EuiNotificationEventMessages } from '../../eui_components/notification/notification_event_messages';