/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.abel.Entity;
import net.sourceforge.plantuml.abel.GroupType;
import net.sourceforge.plantuml.classdiagram.AbstractEntityDiagram;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.ParserPass;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.klimt.color.ColorType;
import net.sourceforge.plantuml.klimt.color.NoSuchColorException;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.plasma.Quark;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexOptional;
import net.sourceforge.plantuml.regex.RegexResult;
import net.sourceforge.plantuml.utils.LineLocation;

public class CommandPackageEmpty
extends SingleLineCommand2<AbstractEntityDiagram> {
    public CommandPackageEmpty() {
        super(CommandPackageEmpty.getRegexConcat());
    }

    static IRegex getRegexConcat() {
        return RegexConcat.build(CommandPackageEmpty.class.getName(), RegexLeaf.start(), new RegexLeaf("package"), RegexLeaf.spaceOneOrMore(), new RegexLeaf(1, "DISPLAY", "([%g][^%g]+[%g]|[^#%s{}]*)"), new RegexOptional((IRegex)new RegexConcat(RegexLeaf.spaceOneOrMore(), new RegexLeaf("as"), RegexLeaf.spaceOneOrMore(), new RegexLeaf(1, "CODE", "([%pLN_.]+)"))), RegexLeaf.spaceZeroOrMore(), new RegexLeaf(1, "COLOR", "(#[0-9a-fA-F]{6}|#?\\w+)?"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("\\{"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("\\}"), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeArg(AbstractEntityDiagram diagram, LineLocation location, RegexResult arg, ParserPass currentPass) throws NoSuchColorException {
        String display;
        String idShort;
        if (arg.get("CODE", 0) == null) {
            if (StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(arg.get("DISPLAY", 0)).length() == 0) {
                idShort = diagram.getUniqueSequence("##");
                display = null;
            } else {
                display = idShort = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(arg.get("DISPLAY", 0));
            }
        } else {
            display = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(arg.get("DISPLAY", 0));
            idShort = arg.get("CODE", 0);
        }
        Quark<Entity> quark = diagram.quarkInContext(false, diagram.cleanId(idShort));
        CommandExecutionResult status = diagram.gotoGroup(location, quark, Display.getWithNewlines(diagram.getPragma(), display), GroupType.PACKAGE);
        if (!status.isOk()) {
            return status;
        }
        Entity p = diagram.getCurrentGroup();
        String color = arg.get("COLOR", 0);
        if (color != null) {
            p.setSpecificColorTOBEREMOVED(ColorType.BACK, diagram.getSkinParam().getIHtmlColorSet().getColor(color));
        }
        diagram.endGroup();
        return CommandExecutionResult.ok();
    }
}

