/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.actors.buffs;

import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.ChampionEnemy;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.FlavourBuff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Frost;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Paralysis;

public class Invulnerability
extends FlavourBuff {
    public static final float DURATION = 3.0f;

    public Invulnerability() {
        this.type = Buff.buffType.POSITIVE;
        this.announced = true;
        this.immunities.add(Paralysis.class);
        this.immunities.add(Frost.class);
    }

    @Override
    public void fx(boolean on) {
        if (!this.target.buffs(ChampionEnemy.class).isEmpty()) {
            return;
        }
        if (on) {
            this.target.sprite.aura(0xFFFF00, 5);
        } else {
            this.target.sprite.clearAura();
        }
    }

    @Override
    public int icon() {
        return 52;
    }

    @Override
    public float iconFadePercent() {
        return Math.max(0.0f, (3.0f - this.visualcooldown()) / 3.0f);
    }

    @Override
    public boolean attachTo(Char target) {
        if (super.attachTo(target)) {
            Buff.detach(target, Paralysis.class);
            Buff.detach(target, Frost.class);
            return true;
        }
        return false;
    }
}

